// $Ip$
//
// Routines for IR control program menu stuff. This file contains those
// menu related routines that are specific to this program only,
//
// Chris Dodge - April 94

#include <dos.h>
#include "..\lib\menu.h"
#include "irmenu.h"

int Repeat = MFALSE;     // Repeat playback or not?

// Put up the initial menu, for various program options.

void MainMenu()
{
	MenuList Menu(YELLOW, BLUE, RED, LIGHTGRAY, MENUX, MENUW, MENUY, MENUH); // Set up the menu
	Menu.AddInfo(Info);
	Menu.SetTitle(MAINT, PTITLE);
	Menu.SetTextScreen();
	Menu.AddMenuItem(6, MAIN1, RecordMenu, MENU_NORM);
	Menu.AddMenuItem(8, MAIN2, PlaybackMenu, MENU_NORM);
	// Menu.AddMenuItem(10, MAIN3, FindTapeIR, MENU_NORM);
	Menu.AddMenuItem(13, MAINQ, QuitProgram, MENU_NORM);
	Menu.Rewind(Menu.GetSize());
	Menu.DrawMenu();
	Menu.TakeInput();
	return;
};


// Menu for IR recording options
int RecordMenu()
{
	MenuList Menu(YELLOW,BLUE,RED,LIGHTGRAY,MENUX,MENUW,MENUY,MENUH); // Set up the menu
	Menu.SetTitle(RECTITLE, PTITLE);
	Menu.AddMenuItem(6, RECCD, RecordCD, MENU_NORM);
	Menu.AddMenuItem(7, RECTAPE, RecordTAPE, MENU_NORM);
	Menu.AddMenuItem(8, RECAMP, RecordAMP, MENU_NORM);
	Menu.AddMenuItem(9, RECSAT, RecordSAT, MENU_NORM);
	Menu.AddMenuItem(10, RECVIDEO, RecordVIDEO, MENU_NORM);
	Menu.AddMenuItem(11, RECTV, RecordTV, MENU_NORM);
	Menu.AddMenuItem(12, RECCAM, RecordCAM, MENU_NORM);
	Menu.AddMenuItem(13, RECCOMP, RecordCOMP, MENU_NORM);
	Menu.AddMenuItem(14, RECQUIT, QuitMenu, MENU_NORM);
	Menu.Rewind(Menu.GetSize());
	Menu.DrawMenu();
	Menu.TakeInput();

	return 0;
};

// Menu for IR playback options
int PlaybackMenu()
{
	MenuList Menu(YELLOW,BLUE,RED,LIGHTGRAY,MENUX,MENUW,MENUY,MENUH); // Set up the menu
	Menu.SetTitle(PLAYTITLE, PTITLE);
	Menu.AddMenuItem(6, RECCD, PlayCD, MENU_NORM);
	Menu.AddMenuItem(7, RECTAPE, PlayTAPE, MENU_NORM);
	Menu.AddMenuItem(8, RECAMP, PlayAMP, MENU_NORM);
	Menu.AddMenuItem(9, RECSAT, PlaySAT, MENU_NORM);
	Menu.AddMenuItem(10, RECVIDEO, PlayVIDEO, MENU_NORM);
	Menu.AddMenuItem(11, RECTV, PlayTV, MENU_NORM);
	Menu.AddMenuItem(12, RECCAM, PlayCAM, MENU_NORM);
	Menu.AddMenuItem(13, PLAYREP, RepeatPlay, MENU_TOGG);
	Menu.AddMenuItem(14, PLAYQUIT, QuitMenu, MENU_NORM);
	Menu.Rewind(Menu.GetSize());
	Menu.DrawMenu();
	Menu.TakeInput();

	return 0;
};


// Function to call Recording of CD signals
int RecordCD()
{
	if (ReadData("CD")) return 1;
	DoRecord();
	MenuDel = MTRUE;
	return 0;
}

// Function to record Camcorder signals
int RecordCAM()
{
	if (ReadData("Camcord")) return 1;
	DoRecord();
	MenuDel = MTRUE;
	return 0;
}

// Function to call Recording of TAPE signals
int RecordTAPE()
{
	if (ReadData("Tape")) return 1;
	DoRecord();
	MenuDel = MTRUE;
	return 0;
}

// Function to call Recording of AMP signals
int RecordAMP()
{
	if (ReadData("Amp")) return 1;
	DoRecord();
	MenuDel = MTRUE;
	return 0;
}

// Function to call Recording of SAT signals
int RecordSAT()
{
	if (ReadData("Sat")) return 1;
	DoRecord();
	MenuDel = MTRUE;
	return 0;
}

// Function to call Recording of VIDEO control signals
int RecordVIDEO()
{
	if (ReadData("Video")) return 1;
	DoRecord();
	MenuDel = MTRUE;
	return 0;
}

// Function to call Recording of TV control signals
int RecordTV()
{
	if (ReadData("TV")) return 1;
	DoRecord();
	MenuDel = MTRUE;
	return 0;
}

// Function to call Recording of spare Rempte Control signals
// which may be used to control computer
int RecordCOMP()
{
	if (ReadData("Comp")) return 1;
	DoRecord();
	MenuDel = MTRUE;
	return 0;
}

// Function to Playback VIDEO IR signals
int PlayVIDEO()
{
	if (ReadData("Video")) return 1;
	DoPlayback(Repeat);
	MenuDel = MTRUE;
	return 0;
}

// Function to Playback Camcorders signals
int PlayCAM()
{
	if (ReadData("Camcord")) return 1;
	DoPlayback(Repeat);
	MenuDel = MTRUE;
	return 0;
}

// Function to Playback TV IR signals
int PlayTV()
{
	if (ReadData("TV")) return 1;
	DoPlayback(Repeat);
	MenuDel = MTRUE;
	return 0;
}

// Function to Playback SAT IR signals
int PlaySAT()
{
	if (ReadData("Sat")) return 1;
	DoPlayback(Repeat);
	MenuDel = MTRUE;
	return 0;
}

// Function to Playback AMP IR signals
int PlayAMP()
{
	if (ReadData("Amp")) return 1;
	DoPlayback(Repeat);
	MenuDel = MTRUE;
	return 0;
}

// Function to Playback CD IR signals
int PlayCD()
{
	if (ReadData("CD")) return 1;
	DoPlayback(Repeat);
	MenuDel = MTRUE;
	return 0;
}

// Function to Playback TAPE IR signals
int PlayTAPE()
{
	return 0;
}

// Function to set wheather play repeats the signal or not
int RepeatPlay()
{
	if (Repeat) Repeat = MFALSE;
	else Repeat = MTRUE;
	return 0;
}

// Prints a string in the message window.
void PrintMsg(char *msg)
{
	textbackground(LIGHTGRAY);
	textcolor(BLACK);
	window(5,19,76,22);
	gotoxy(1,4);             // Put the cursor at the bottom of the screen.
	// Clear line first, then print string.
	cprintf("\n                                                               ");
	gotoxy(1,4);             // Put the cursor at the bottom of the screen.
	cprintf("%s",msg);
	return;
}

// Info function for this program
void Info()
{
	int Sx, Sy, Ex, Ey;
	int Back = GREEN;
	int Fore = WHITE;

	textbackground(Back);
	textcolor(Fore);
	window(1,1,80,25);
	clrscr();
	Sx = 30; Sy = 12; Ex = 51; Ey = 14;

	TextBox(Sx,Sy,Ex,Ey);
	for (int i=0, j=0; i<10; i++,j+=2) {
		window(Sx-j,Sy-i,Ex+j,Ey+i);
		textbackground(BLUE);
		clrscr();
		textcolor(Fore);
		window(1,1,80,25);
		TextBox(Sx-j,Sy-i,Ex+j,Ey+i);     // Draw new box
		delay(80);
	}
	window(Sx-j,Sy-i,Ex+j,Ey+i);
	textcolor(YELLOW);
	Printxy(23,4,"IR: Version 1.2");
	gotoxy(23,5); for (i=0; i<15; i++) putch(0xcd);
	textcolor(WHITE);
	Printxy(5,7,"With appropriate hardware, this program records, ");
	Printxy(5,8,"analyses, saves and outputs signals from IR remote");
	Printxy(5,9,"controllers.");
	Printxy(5,11,"These can then be used in other programs for");
	Printxy(5,12,"computer control of equipment etc.");
	textcolor(LIGHTRED);
	Printxy(5,14,"Data file:   IRINFO.DAT");
	Printxy(5,15,"Output file: IRTEMP.DAT");
	textcolor(YELLOW);
	Printxy(5,17,"Written by: Chris Dodge");
	Printxy(5,19,"Problems, ideas, improvements......please contact");
	Printxy(5,20,"me at:");
	textcolor(LIGHTCYAN);
	Printxy(14,20,"cdodge"); putch(0x40); Printxy(21,20,"awi-bremerhaven.de");
	MenuDel = MTRUE;
	getch();
}

